﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class SignUp : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (!IsPostBack)
            {
                BindSubject();
                BindDropListState();
               

            }


        }
        catch (Exception er)
        {
            WriteErrorLog(er);

            Response.Redirect("error.aspx", false);

        }

    }



    public void WriteErrorLog(Exception ex)
    {
        try
        {
            string webPageName = Path.GetFileName(Request.Path);
            string errorLogFilename = "ErrorLog_" + Server.HtmlEncode(DateTime.Now.ToString("dd-MM-yyyy") + ".txt");
            string path = Server.MapPath("~/ErrorLogFiles/" + errorLogFilename);
            if (File.Exists(path))
            {
                using (StreamWriter stwriter = new StreamWriter(Server.HtmlEncode(path), true))
                {
                    stwriter.WriteLine("Error Log Start as on " + Server.HtmlEncode(DateTime.Now.ToString("hh:mm tt")));
                    stwriter.WriteLine("WebPage Name :" + webPageName);
                    stwriter.WriteLine("Message:" + Server.HtmlEncode(ex.Message.ToString()));
                    stwriter.WriteLine("Line:" + Server.HtmlEncode(ex.StackTrace.ToString()));
                    stwriter.WriteLine("Line:" + Server.HtmlEncode(ex.GetType().Name.ToString()));
                    stwriter.WriteLine("End");
                }
            }
            else
            {
                StreamWriter stwriter = File.CreateText(Server.HtmlEncode(path));
                stwriter.WriteLine("Error Log Start as on " + Server.HtmlEncode(DateTime.Now.ToString("hh:mm tt")));
                stwriter.WriteLine("WebPage Name :" + webPageName);
                stwriter.WriteLine("Message:" + Server.HtmlEncode(ex.Message.ToString()));
                stwriter.WriteLine("Line:" + Server.HtmlEncode(ex.StackTrace.ToString()));
                stwriter.WriteLine("Line:" + Server.HtmlEncode(ex.GetType().Name.ToString()));
                stwriter.WriteLine("End");
                stwriter.Close();
            }
        }
        catch (System.Threading.ThreadAbortException)
        {

        }
        catch (Exception er)
        {
            WriteErrorLog(er);
            Response.Redirect("error.aspx", false);

        }
    }


    private void BindDropListState()
    {
        try
        {

            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["trmsConn"].ConnectionString))
            {
                string com = "select stateCode,stateName from mstState where status=1 order by stateName ";
                using (SqlDataAdapter adpt = new SqlDataAdapter(com, con))
                {
                    using (DataTable dt = new DataTable())
                    {
                        adpt.Fill(dt);
                        DDstate.DataSource = dt;

                        DDstate.DataTextField = "stateName";
                        DDstate.DataValueField = "stateCode";
                        DDstate.DataBind();
                        DDstate.Items.Insert(0, new ListItem("Select State", ""));

                    }
                }
            }
        }
        catch (Exception er)
        {
            WriteErrorLog(er);
            Response.Redirect("error.aspx", false);

        }
    }
    private void BindSubject()
    {
        try
        {

            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["trmsConn"].ConnectionString))
            {
                string com = "select subjectCode,subjectName from tblSubject where status=1 order by subjectName";
                using (SqlDataAdapter adpt = new SqlDataAdapter(com, con))
                {
                    using (DataTable dt = new DataTable())
                    {
                        adpt.Fill(dt);
                        DDSubject.DataSource = dt;
                        DDSubject.DataBind();
                        DDSubject.DataTextField = "subjectName";
                        DDSubject.DataValueField = "subjectCode";
                        DDSubject.DataBind();
                        DDSubject.Items.Insert(0, new ListItem("Select Subject", ""));
                    }
                }
            }
        }
        catch (Exception er)
        {
            WriteErrorLog(er);
            Response.Redirect("error.aspx", false);
        }
    }

    protected void btnRegister_Click(object sender, EventArgs e)
    {
        try
        {

            if (txtname.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Enter Name');", true);
                txtname.Focus();
            }


            else if (txtContactNumber.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Enter Mobile');", true);
                txtContactNumber.Focus();

            }
            else if (txtemail.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Enter Email');", true);
                txtemail.Focus();
            }
            else if (DDSubject.SelectedIndex == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Select Subjects');", true);
                DDSubject.Focus();
            }
            else if (txtQuali.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Enter Qulification');", true);
                txtQuali.Focus();
            }
            else if (txtAddress.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Enter Address');", true);
                txtAddress.Focus();
            }

            else if (DDstate.SelectedIndex == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Select State');", true);
                DDstate.Focus();
            }


            else if (txtCity.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Enter City');", true);
                txtCity.Focus();
            }
            else if (!FileUpload1.HasFile)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('You must select a valid file to upload');", true);
                FileUpload1.Focus();
            }
            else if (FileUpload1.PostedFile.ContentLength == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('You must select a non empty file to upload.');", true);
                FileUpload1.Focus();
            }
            else if (int.Parse(FileUpload1.PostedFile.ContentLength.ToString()) > 3145728)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('File size max 3MB! Try Again!.');", true);
                FileUpload1.Focus();
            }
            else
            {
                if (FileUpload1.PostedFile.ContentLength > 0)
                {
                    string ext = System.IO.Path.GetExtension(FileUpload1.PostedFile.FileName);
                    if (ext == ".png" || ext == ".PNG" || ext == ".jpg" || ext == ".JPG" || ext == ".jpeg" || ext == ".JPEG")
                    {

                        Random rnd = new Random();
                        int otp = rnd.Next(100000, 999999);
                        string Filename = DateTime.Now.ToString("ddMMyyyyHHmmss") + otp + ext;
                        string FilePath = Server.MapPath("~/Photo/") + Filename.Trim();

                        using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["trmsConn"].ConnectionString))
                        {
                            conn.Open();

                            string QueryEmail = "select * from tblLogin where emailId='"+txtemail.Text.Trim()+"'";
                            using (SqlCommand cmdemail = new SqlCommand(QueryEmail, conn))
                            {
                                using (SqlDataAdapter daemail = new SqlDataAdapter(cmdemail))
                                {
                                    DataTable dtemail = new DataTable();
                                    daemail.Fill(dtemail);
                                    if (dtemail.Rows.Count == 0)
                                    {
                                        string Query = "select count(transId)+1 as SNo from tbllogin where status=1";
                                        using (SqlCommand cmd = new SqlCommand(Query, conn))
                                        {
                                            using (SqlDataAdapter da = new SqlDataAdapter(cmd))
                                            {
                                                DataTable dt = new DataTable();
                                                da.Fill(dt);
                                                int code = Convert.ToInt32(dt.Rows[0]["SNo"].ToString());
                                                FileUpload1.PostedFile.SaveAs(FilePath);
                                                string Queryinsert = "INSERT INTO tblLogin(role,userId,userName,mobileNo,emailId,subject,photo,qulification,address,state,city,password,addedDate,status)VALUES(100,'U00" + code + "','" + txtname.Text.Trim() + "','" + txtContactNumber.Text.Trim() + "','" + txtemail.Text.Trim() + "','" + DDSubject.SelectedValue + "','" + Filename + "','" + txtQuali.Text.Trim() + "','" + txtAddress.Text.Trim() + "','" + DDstate.SelectedValue.ToString() + "','" + txtCity.Text.Trim() + "','" + txtPassword.Text.Trim() + "',getdate(),1)";
                                                
                                                
                                                using (SqlCommand cmdinsert = new SqlCommand(Queryinsert, conn))
                                                {
                                                    int i = cmdinsert.ExecuteNonQuery();
                                                    if (i > 0)
                                                    {
                                                        ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('User Registed Successfully');window.location='" + Request.ApplicationPath + "Signin.aspx';", true);
                                                    }
                                                    conn.Close();
                                                }
                                            }
                                        }
                                    }
                                    else
                                    {
                                        ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('Email Id Already Register');", true);
                                        txtemail.Focus();
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "alert('png,jpg and jpeg file are supported.Try again!');", true);
                        FileUpload1.Focus();
                    }
                }
            }
        }

        catch (Exception er)
        {
            WriteErrorLog(er);
            Response.Redirect("error.aspx", false);

        }
    }
}
